﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.PocketOutlook;
using Microsoft.WindowsMobile.Forms;

namespace Email
{
    public partial class Form1 : Form
    {
        string adresEmailAdresata;
        bool zamknijPoWyslaniu = false;

        OutlookSession outlook = new OutlookSession();

        public Form1(string adresEmailAdresata)
        {
            InitializeComponent();

            var konta = from EmailAccount konto in outlook.EmailAccounts
                        select konto.Name;
            kontaComboBox.DataSource = konta.ToArray<string>();            

            this.adresEmailAdresata = adresEmailAdresata;
            sprawdzKontakt(adresEmailAdresata);
        }

        private void kontaktyButton_Click(object sender, EventArgs e)
        {
            ChooseContactDialog wybierzKontakt = new ChooseContactDialog();
            wybierzKontakt.RequiredProperties =
                new ContactProperty[] { ContactProperty.AllEmail };
            wybierzKontakt.Title = "Wybierz adresata";
            wybierzKontakt.ChooseContactOnly = false;
            if (wybierzKontakt.ShowDialog() == DialogResult.OK)
            {
                adresEmailAdresata = wybierzKontakt.SelectedPropertyValue;
                adresatTextBox.Text = wybierzKontakt.SelectedContactName
                                       + " <" + adresEmailAdresata + ">";
                wyslijMenuItem.Enabled = true;
            }
        }

        private void zalacznikMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tekstTextBox.Text = openFileDialog1.FileName;
                zalacznikMenuItem.Checked = true;
            }
        }

        private void usunZalacznikMenuItem_Click(object sender, EventArgs e)
        {
            openFileDialog1.FileName = "";
            zalacznikMenuItem.Checked = false;
        }

        private void zakonczMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void wyslijMenuItem_Click(object sender, EventArgs e)
        {
            EmailMessage email = new EmailMessage();
            email.To.Add(new Recipient(adresEmailAdresata));
            email.BodyText = tekstTextBox.Text;
            email.Subject = tytulTextBox.Text;            
            
            if (zalacznikMenuItem.Checked) email.Attachments.Add(new Attachment(openFileDialog1.FileName));
            
            try
            {
                EmailAccount konto = outlook.EmailAccounts[kontaComboBox.Text]; //rozpoznawanie konta po nazwie
                konto.Send(email); //lub email.Send(konto);                
                MessagingApplication.Synchronize(konto);
                MessageBox.Show("Wiadomość została umieszczona w skrzynce nadawczej konta "+konto.Name+"!");
                if (zamknijPoWyslaniu) Close();
            }
            catch 
            { 
                MessageBox.Show("Nie udało się wysłać wiadomości!");                 
            }            
        }

        public void sprawdzKontakt(string adresEmail)
        {
            if (adresEmail == null || adresEmail == "") return;

            OutlookSession outlook = new OutlookSession();
            var kontakty = from Contact kontakt in outlook.Contacts.Items
                           where (kontakt.Email1Address == adresEmail) ||
                                 (kontakt.Email2Address == adresEmail) ||
                                 (kontakt.Email3Address == adresEmail)
                           select kontakt.FirstName + " " + kontakt.LastName + " <" + adresEmail + ">";
            if (kontakty.Count() == 0) adresatTextBox.Text = adresEmail;
            else adresatTextBox.Text = kontakty.First<string>();
            wyslijMenuItem.Enabled = true;
            zamknijPoWyslaniu = true;
        }
    }
}